/*******************************************************************************
********************************************************************************
** COPYRIGHT:      (c) 1995-2004 Rohde & Schwarz, Munich
** MODULE:         EB200UdpSock.H
** ABBREVIATION:   
** COMPILER:       VC++ 5.0
** LANGUAGE:       C/C++
** AUTHOR:         Martin Hisch
** ABSTRACT:       
** PREMISES:       
** REMARKS:        
** HISTORY:        
**	2002-6-3: (Mu)  newStepScheme in OptHeaderDScan with VersionMinor >= 0x24
**	2002-3-4: (Mu)	Channels / sec ,m_nChannels
**	2000-11-30:(ks) Include Not-Swapping.
**	2000-5-29: (Hh)	Creation 
** REVIEW:         
********************************************************************************/



/* GLOBAL DEFINES ********************************************************/
#ifndef EB200UdpSock_DEF
#define EB200UdpSock_DEF

#define TAG_NEW_GENERICATT_LIMIT    5000

enum TAGS
{
    FSCAN           = 101,
    MSCAN           = 201,
    DSCAN           = 301,
    AUDIO           = 401,
    IFPAN           = 501,
    FASTL           = 601,
    LISTF           = 701,
    CW              = 801,
    IF              = 901,
    VIDEO           = 1001,
    VIDEOPAN        = 1101,
    PSCAN           = 1201,
    SELCALL         = 1301,
    DFPAN           = 1401,
    PHD             = 1601,
    GPSCompass      = 1801,
    RDPAN           = 5001,
    SCDPAN          = 5101,
    SDW             = 5201,
    LAST_TAG
};

enum FLAGS
{
    LEVEL           = 0x1,
    OFFSET          = 0x2,
    FSTRENGTH       = 0x4,
    AM              = 0x8,
    AMPOS           = 0x10,
    AMNEG           = 0x20,
    FM              = 0x40,
    FMPOS           = 0x80,
    FMNEG           = 0x100,
    PM              = 0x200,
    BAND            = 0x400,
    DF_LEVEL        = 0x800,
    AZIMUTH         = 0x1000,
    DF_QUALITY      = 0x2000,
    DF_FSTRENGTH    = 0x4000,
    CHANNEL         = 0x00010000,
    FREQ_LOW        = 0x00020000,
    FREQ_HIGH       = 0x00200000,
    SWAP            = 0x20000000, // swap ON means: do NOT swap (for little endian machines)
    SIGGTSQU        = 0x40000000,
    OPTHEADER       = 0x80000000
};

enum FLAGS_HIGH
{
    WDE_THR         = 0x1,
    WDE_FLAG        = 0x2,
    SDW_FLAG        = 0x4
};

#pragma pack(push, 1)
typedef struct GenericAttribute
{
    unsigned short        tag;
    unsigned short        length;
    unsigned char        data[1];
} GENERIC_ATTRIBUTE_TYPE;

typedef struct NewGenericAttribute
{
    unsigned short        tag;
    unsigned short        reserved1;
    unsigned long         length;
    unsigned long         reserved2[4];
    unsigned char        data[1];
} NEW_GENERIC_ATTRIBUTE_TYPE;

typedef struct EB200DatagramFormat
{
    unsigned long         MagicNumber;
    unsigned short        VersionMinor;
    unsigned short        VersionMajor;
    unsigned short        SequenceNumber;
    unsigned short        reserved;
    unsigned long         DataSize; // sizeof complete datagram incl. header (32 bit aligned)
    struct GenericAttribute Attribute[1];
} EB200_DATAGRAM_TYPE;

#define EB200_DATAGRAM_HEADER_SIZE  (sizeof( EB200_DATAGRAM_TYPE ) - sizeof( GENERIC_ATTRIBUTE_TYPE ))

typedef struct CommonHeader 
{
    unsigned short      NumberOfTraceItems;
    unsigned char       ChannelNumber; /* 0 = main RX; 0x77 is also main RX (old value); 1 = DDC1; 2 = DDC2; ... */
    unsigned char       OptionalHeaderLength;
    unsigned long       SelectorFlags;
} COMMON_HEADER_TYPE;

typedef struct NewCommonHeader 
{
    unsigned long       NumberOfTraceItems;
    unsigned long       ChannelNumber; /* 0 = main RX; 0x77 is also main RX (old value); 1 = DDC1; 2 = DDC2; ... */
    unsigned long       OptionalHeaderLength;
    unsigned long       SelectorFlagsLow;
    unsigned long       SelectorFlagsHigh;
    unsigned long       reserved[4];
} NEW_COMMON_HEADER_TYPE;

/* Optional Headers */
typedef struct OptHeaderDScan
{
    unsigned long       StartFreq_low;
    unsigned long       StopFreq_low;
    unsigned long       StepFreq;
    unsigned long       FMark_low;
    unsigned short      BWZoom;
    short               RefLevel;
    unsigned short      newStepScheme;
    unsigned long       StartFreq_high;
    unsigned long       StopFreq_high;
    unsigned long       FMark_high;
} OPT_HEADER_DSCAN_TYPE;

typedef struct OptHeaderPScan
{
    unsigned long       StartFreq_low;
    unsigned long       StopFreq_low;
    unsigned long       StepFreq;
    unsigned long       StartFreq_high;
    unsigned long       StopFreq_high;
    char                reserved[4];
    DWORDLONG           OutputTimestamp; /* nanoseconds since Jan 1st, 1970, without leap seconds */
} OPT_HEADER_PSCAN_TYPE;

typedef struct OptHeaderFScan
{
    short               CycleCount;
    short               HoldTime;
    short               DwellTime;
    short               DirectionUp;
    short               StopSignal;
    unsigned long       StartFreq_low;
    unsigned long       StopFreq_low;
    unsigned long       StepFreq;
    unsigned long       StartFreq_high;
    unsigned long       StopFreq_high;
    char                reserved[2];
    DWORDLONG           OutputTimestamp; /* nanoseconds since Jan 1st, 1970, without leap seconds */
} OPT_HEADER_FSCAN_TYPE;

typedef struct OptHeaderMScan
{
    short               CycleCount;
    short               HoldTime;
    short               DwellTime;
    short               DirectionUp;
    short               StopSignal;
    char                reserved[6];
    DWORDLONG           OutputTimestamp; /* nanoseconds since Jan 1st, 1970, without leap seconds */
} OPT_HEADER_MSCAN_TYPE;

typedef struct OptHeaderIFPan
{
    unsigned long       Freq_low;
    unsigned long       FSpan;
    short               AvgTime;
    short               AvgType;
    unsigned long       MeasureTime;
    unsigned long       Freq_high;
    signed long         DemodFreqChannel;
    unsigned long       DemodFreq_low;
    unsigned long       DemodFreq_high;
    DWORDLONG           OutputTimestamp; /* nanoseconds since Jan 1st, 1970, without leap seconds */
} OPT_HEADER_IFPAN_TYPE;

typedef struct OptHeaderRDPan
{
    unsigned long       Freq_low;
    unsigned long       Freq_high;
    unsigned long       FSpan;
    unsigned long       FStep;
    unsigned long       detectionsPer10Sec; /* Detections per 10 seconds                         */
    unsigned long       parallelDetections; /* Max. parallel detections                          */
    unsigned long       usedExcitersPer10Sec;/* Used exictors per 10 seconds                      */
    signed long         relThreshold;       /* Relative Threshold in dB                          */
    DWORDLONG           OutputTimestamp; /* nanoseconds since Jan 1st, 1970, without leap seconds */
} OPT_HEADER_RDPAN_TYPE;

typedef struct OptHeaderSCDPan
{
    unsigned long       Freq_low;
    unsigned long       Freq_high;
    unsigned long       detectionsPer10Sec; /* Detections per 10 seconds                         */
    unsigned long       parallelDetections; /* Max. parallel detections                          */
    unsigned long       usedExcitersPer10Sec;/* Used exictors per 10 seconds                      */
    DWORDLONG           OutputTimestamp; /* nanoseconds since Jan 1st, 1970, without leap seconds */
} OPT_HEADER_SCDPAN_TYPE;

typedef struct OptHeaderSDW
{
    unsigned int        RxFreqLow;
    unsigned int        RxFreqHigh;
    unsigned int        RxSpan;
} OPT_HEADER_SDW_TYPE;

typedef struct SDWSample
{
    unsigned int word0;
    unsigned int word1;
    unsigned int word2;
    unsigned int word3;
    unsigned int word4;
    unsigned int word5;
    unsigned int word6;
    unsigned int word7;
} SDW_SAMPLE_TYPE;

typedef struct OptHeaderAudio
{
    unsigned short        AudioMode;
    unsigned short        FrameLength;
    unsigned long         Freq_low;
    unsigned long         Bandwidth;
    unsigned short        Demodulation;
    char                  DemodulationString[8];
    unsigned long         Freq_high;
    char                  reserved[6];
    DWORDLONG             OutputTimestamp; /* nanoseconds since Jan 1st, 1970, without leap seconds */
} OPT_HEADER_AUDIO_TYPE;


// Flagdefinition for IF data via LAN
#define IF_DATA_SIGNAL_VALID        (0x01)
#define IF_DATA_BLANKING            (0x02)
#define IF_DATA_ANT_FACTOR_VALID    (0x8000)

typedef struct OptHeaderIF
{
    unsigned short        IFMode;
    unsigned short        FrameLength;
    unsigned long         SamplerRate;
    unsigned long         Freq_low;
    unsigned long         Bandwidth;
    unsigned short        Demodulation;
    short                 RxAttenuation;
    unsigned short        Flags;
    short                 kFactor;
    char                  DemodulationString[8];
    DWORDLONG             SampleCount;       
    unsigned long         Freq_high;
    char                  reserved2[4];
    DWORDLONG             StartTimestamp; /* nanoseconds since Jan 1st, 1970, without leap seconds */
} OPT_HEADER_IF_TYPE;

typedef OPT_HEADER_IF_TYPE OPT_HEADER_VIDEO_TYPE;

typedef struct OptHeaderCw
{
    unsigned long       Freq_low;
    unsigned long       Freq_high;
    DWORDLONG           OutputTimestamp; /* nanoseconds since Jan 1st, 1970, without leap seconds */
} OPT_HEADER_CW_TYPE;

typedef struct OptHeaderSelcall
{
    unsigned long       Freq_low;
    unsigned long       Bandwidth;
    unsigned short      Demodulation;
    char                DemodulationString[8];
    unsigned short      SelcallMode;
    char                SelcallModeString[10];
    unsigned long       Freq_high;
    char                reserved[6];
    DWORDLONG           OutputTimestamp; /* nanoseconds since Jan 1st, 1970, without leap seconds */
} OPT_HEADER_SELCALL_TYPE;

typedef struct GPSHeader
{
  signed short   bValid;               /* denotes whether GPS data are to be
                                    considered valid                                 */
  signed short   iNoOfSatInView;       /* number of satellites in view 0-12;      
                                    only valid, if GGA msg is received,
                                    else -1 (GPS_UNDEFINDED)                         */ 
  signed short   iLatRef;        /* latitude direction ('N' or 'S')                  */  
  signed short   iLatDeg;        /* latitude degrees                                 */
  float          fLatMin;        /* geographical latitude: minutes                   */
  signed short   iLonRef;        /* longitude direction ('E' or 'W')                 */
  signed short   iLonDeg;        /* longitude degrees                                */  
  float          fLonMin;        /* geographical longitude: minutes                  */
  float          fPdop;          /* Mean (Position) Dilution Of Precision; */

} GPSHEADER_TYPE;

typedef struct GPSCompassSample
{
    unsigned short        Heading;
    short                 HeadingType;
    GPSHEADER_TYPE        GPSHeader;
    short                 AntennaValid;
    short                 AntennaTiltOver;
    short                 AntennaElevation;
    short                 AntennaRoll;
}GPS_SAMPLE_TYPE;



#define MAX_ANTVOLT_COUNT   9

typedef struct
{
    float x;
    float y;
} CPLX_TYPE;

typedef struct OptHeaderDFPan
{
	unsigned long					Freq_low;
	unsigned long					Freq_high;
	unsigned long					FreqSpan;
	signed long	    				DFThresholdMode;
	signed long		    			DFThresholdValue;
    unsigned long                   DfBandwidth;
    unsigned long                   StepWidth;
    unsigned long                   DFMeasureTime;
    signed long                     DFOption;
    unsigned short                  CompassHeading;
    signed short                    CompassHeadingType;
    signed long                     AntennaFactor;
    signed long                     DemodFreqChannel;
	unsigned long					DemodFreq_low;
	unsigned long					DemodFreq_high;
    DWORDLONG                       OutputTimestamp; /* nanoseconds since Jan 1st, 1970, without leap seconds */
    GPSHEADER_TYPE                  GPSHeader;
} OPT_HEADER_DFPAN_TYPE;



typedef struct OptHeaderGPSCompass
{
    DWORDLONG                       OutputTimestamp; /* nanoseconds since Jan 1st, 1970, without leap seconds */   
    
} OPT_HEADER_GPS_TYPE;


typedef struct OptHeaderPIFPan
{
	UINT32					Freq_low;
	UINT32					Freq_high;
    UINT32                  FreqSpan;
    INT32                   nReferenceLevel;    /* 1/10 dBuV */
    INT32                   nHeightLevel;       /* 1/10 dB */
    INT32                   nHeight;            /* Pixel */
    INT32                   nWidth;             /* Pixel */
    INT32                   nMaxY;              /* Y-Koordinate */
    INT32                   nMinY;              /* Y-Koordinate */
    INT32                   nStartY;            /* Y-Koordinate */
    INT32                   nStopY;             /* Y-Koordinate */
    UINT32                  nPictureNumber;     /* No of current picture */
    DWORDLONG               OutputTimestamp;    /* nanoseconds since Jan 1st, 1970, without leap seconds */
    INT32                   nMode;              /* PIFPAN mode (histogram or pulse) */
} OPT_HEADER_PIFPAN_TYPE;

#pragma pack(pop)

/* dig. AF:  Audioformat description*/
typedef struct
{
    unsigned long           nSampleRate;
    unsigned short          nBitsPerSample;
    unsigned short          nNoOfChannels;
    unsigned long           nRateInBytesPerSec;
    unsigned char           cFrameLength;
} AUDIO_FORMAT_TYPE;

class CEB200UdpSock;

typedef void (CEB200UdpSock::*PMEMBER)(struct GenericAttribute *);


typedef struct TagList
{
    enum TAGS   nTag;
    PMEMBER     pMethode;    
} TAGLIST_TYPE;

#include "sound.h"
#include "wavfile.h"

#define  PCM_MAX_AUDIO  12
#define  GSM_AUDIO  13

class CEB200UdpSock 
{
public:
    CEB200UdpSock( bool bTcp, unsigned short TracPort, unsigned long ulRemoteAddress, unsigned short RecvPort = 0 );
    virtual ~CEB200UdpSock() {  };

    virtual void    Init(void);
    virtual void    CloseTrace(void);
            BOOL    CheckDGram(struct EB200DatagramFormat *pDGram, unsigned long nLen);
            void    ParseData(struct EB200DatagramFormat *pDGram, int nLen);
    virtual void    ParseOtherData(void *pData, int nLen) {};
    virtual int     GetUnknownPacketLen(SOCKET nSock, void *pData, int *pLen) { return 0; } ;


    virtual void    Scan(struct GenericAttribute *pAttr);
    virtual void    FScan(struct GenericAttribute *pAttr);
    virtual void    MScan(struct GenericAttribute *pAttr);
    virtual void    DScan(struct GenericAttribute *pAttr);
    virtual void    IFPan(struct GenericAttribute *pAttr);
    virtual void    DFPan(struct GenericAttribute *pAttr);
    virtual void    Audio(struct GenericAttribute *pAttr);
    virtual void    IF(struct GenericAttribute *pAttr);
    virtual void    Video(struct GenericAttribute *pAttr);
    virtual void    List(struct GenericAttribute *pAttr);
    virtual void    FastLev(struct GenericAttribute *pAttr);
    virtual void    Cw(struct GenericAttribute *pAttr);
    virtual void    PScan(struct GenericAttribute *pAttr);
    virtual void    VideoPan(struct GenericAttribute *pAttr);
    virtual void    Selcall(struct GenericAttribute *pAttr);
    virtual void    PHD(struct GenericAttribute *pAttr);
    virtual void    GPSCompass(struct GenericAttribute *pAttr);
    virtual void    RDPan(struct GenericAttribute *pAttr);
    virtual void    SCDPan(struct GenericAttribute *pAttr);
    virtual void    SDW(struct GenericAttribute *pAttr);

    int     GetTracPort() { return m_nPort; };
    SOCKET  GetTracSock() { return m_Sock; };
    bool    IsStopped() { return m_bStop; };
    virtual void    DoStatistics(int);

    virtual void    SetIFRecording(char *pcFilename, bool bRaw);
    virtual void    SetCSRecording(char *pcFilename);
    virtual void    SetAFRecording(char *pcFilename);

protected:
    void fprint_short_formated(short pData);
    static	int	Vprintf(const char *format, ...);
    static  float ntohf( float netfloat);
    static unsigned int EB200UdpThreadProc(void *pParam);
           unsigned int doThreadProc(void);

            void    ParseSelectorFlags(unsigned long nSel, void *pData, int nCount);
            void    ParseCommonHeader( struct CommonHeader *pCommon );
            void    ParseCommonHeader( struct NewCommonHeader *pCommon );

    virtual void    CloseFiles(void)
            {
                  if (m_ctIQFile.IsOpen())
                  {
                      m_ctIQFile.Close();
                  }
                  if (m_pRawFile != NULL)
                  {
                      fclose(m_pRawFile);
                  }
            };
private:
            CEB200UdpSock();    // hide default ctor since we require args

            void    SwapBuffer(short *pData, int nCount) {
                        for (int ii = 0; ii < nCount; ii++) {
                            pData[ii] = ntohs(pData[ii]);
                        }
                    }
            void    SwapBuffer(long *pData, int nCount) {
                        for (int ii = 0; ii < nCount; ii++) {
                            pData[ii] = ntohl(pData[ii]);
                        }
                    }
            DWORDLONG Swap64(DWORDLONG data) {
                DWORD *pLong = (DWORD*)&data;
                DWORD nLong0, nLong1;
                nLong0 = pLong[0];
                nLong1 = pLong[1];
                pLong[0] = ntohl(nLong1);
                pLong[1] = ntohl(nLong0);
                return data;
            }
protected:
    static const AUDIO_FORMAT_TYPE m_AudioFormats[GSM_AUDIO+1];

    unsigned short          m_nSequenceNumber;  // sequence counter
           bool             m_bTcp;             // flag for using TCP
           int              m_nPort;            // trace port number
           int              m_nRecvPort;        // local port number (optional)
           SOCKET           m_Sock;             // trace socket descriptor
           struct sockaddr_in  m_Addr;
           bool             m_bStop;            // flag for closing
           CSound           m_Sound;            // Sound output class
           bool             m_bIFRecording;     // Indicates if IF recording is active
           bool             m_bCSRecording;     // Indicates if CS recording is active
           bool             m_bAFRecording;     // Indicates if AF recording is active
           bool             m_bRaw;             // Raw data recording
           CWAVFile         m_ctIQFile;         // File object for IQ recording
           FILE             *m_pCSFile;         // File pointer to CS data file
           FILE             *m_pRawFile;        // File pointer to raw data file
           bool             m_b64BitFrequencies;
           bool             m_bTimestamp;       // timestamp and channel number available
           bool             m_bNewGenericAtt;   // new generic attribute available
           unsigned long    m_nDDCx;            // receiver instance / DDC number
           char             m_cDDCx[8];         // and it's name

           // Pointers to different data types
           short            *m_pLevel;
           long             *m_pOffset;
           short            *m_pFStrength;
           short            *m_pAM;
           short            *m_pAMPos;
           short            *m_pAMNeg;
           long             *m_pFM;
           long             *m_pFMPos;
           long             *m_pFMNeg;
           short            *m_pPM;
           long             *m_pBW;
           short            *m_pAzimuth;
           short            *m_pQuality;
           short            *m_pDFLevel;
           short            *m_pDFFStrength;
           unsigned short   *m_pChannel;
           unsigned long    *m_pFreq;
           unsigned long    *m_pFreqHigh;
           
           // some statistics
           int              m_nFScanPackets;    
           int              m_nMScanPackets;
           int              m_nDScanPackets;
           int              m_nIFPanPackets;
           int              m_nAudioPackets;
           int              m_nIFPackets;
           int              m_nVideoPackets;
           int              m_nFastLevPackets;
           int              m_nListPackets;
           int              m_nCwPackets;
           int              m_nPScanPackets;
           int              m_nVideoPanPackets;
           int              m_nSelcallPackets;
           int              m_nDFPanPackets;
           int              m_nPHDPackets;
           int              m_nRDPanPackets;
           int              m_nSCDPanPackets;
           int              m_nSDWPackets;
           unsigned long    m_oldtime;
           int              m_nCount;
           int              m_nChannels;
           int              m_nTotalLen;
           double           m_lfRms;
           short            m_nRxAtt;
           unsigned short   m_flags;
           short            m_kFactor;
           char             m_sDemod[8];
           DWORDLONG        m_nIFSampleCounter;
           DWORDLONG        m_nVideoSampleCounter;
           bool             m_bIsWDE;
};

enum 
{
    CCIR7,
    CCIR1, 
    CCITT,
    EEA,
    EIA,
    EURO,
    NATEL,
    VDEW,
    ZVEI1,
    ZVEI2,
    DTMF,
    CTCSS,
    DCS,
    MAX_SELCALL_MODES   // maximale Anzahl von Selcall Verfahren
};

#endif


/* GLOBAL VARIABLES **********************************************************/


/* GLOBAL CONSTANTS **********************************************************/


/* GLOBAL FUNCTIONS **********************************************************/

